@extends('user.layouts.master')
@section('css')
@endsection
@section('user-content')
<!-- Page content -->
<div class="container-fluid mt-2">
<link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
<!-- Styles -->
<style>
   /*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */
   html{line-height:1.15;-webkit-text-size-adjust:100%}body{margin:0}a{background-color:transparent}[hidden]{display:none}html{font-family:system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;line-height:1.5}*,:after,:before{box-sizing:border-box;border:0 solid #e2e8f0}a{color:inherit;text-decoration:inherit}svg,video{display:block;vertical-align:middle}video{max-width:100%;height:auto}.bg-white{--bg-opacity:1;background-color:#fff;background-color:rgba(255,255,255,var(--bg-opacity))}.bg-gray-100{--bg-opacity:1;background-color:#f7fafc;background-color:rgba(247,250,252,var(--bg-opacity))}.border-gray-200{--border-opacity:1;border-color:#edf2f7;border-color:rgba(237,242,247,var(--border-opacity))}.border-t{border-top-width:1px}.flex{display:flex}.grid{display:grid}.hidden{display:none}.items-center{align-items:center}.justify-center{justify-content:center}.font-semibold{font-weight:600}.h-5{height:1.25rem}.h-8{height:2rem}.h-16{height:4rem}.text-sm{font-size:.875rem}.text-lg{font-size:1.125rem}.leading-7{line-height:1.75rem}.mx-auto{margin-left:auto;margin-right:auto}.ml-1{margin-left:.25rem}.mt-2{margin-top:.5rem}.mr-2{margin-right:.5rem}.ml-2{margin-left:.5rem}.mt-4{margin-top:1rem}.ml-4{margin-left:1rem}.mt-8{margin-top:2rem}.ml-12{margin-left:3rem}.-mt-px{margin-top:-1px}.max-w-6xl{max-width:72rem}.min-h-screen{min-height:100vh}.overflow-hidden{overflow:hidden}.p-6{padding:1.5rem}.py-4{padding-top:1rem;padding-bottom:1rem}.px-6{padding-left:1.5rem;padding-right:1.5rem}.pt-8{padding-top:2rem}.fixed{position:fixed}.relative{position:relative}.top-0{top:0}.right-0{right:0}.shadow{box-shadow:0 1px 3px 0 rgba(0,0,0,.1),0 1px 2px 0 rgba(0,0,0,.06)}.text-center{text-align:center}.text-gray-200{--text-opacity:1;color:#edf2f7;color:rgba(237,242,247,var(--text-opacity))}.text-gray-300{--text-opacity:1;color:#e2e8f0;color:rgba(226,232,240,var(--text-opacity))}.text-gray-400{--text-opacity:1;color:#cbd5e0;color:rgba(203,213,224,var(--text-opacity))}.text-gray-500{--text-opacity:1;color:#a0aec0;color:rgba(160,174,192,var(--text-opacity))}.text-gray-600{--text-opacity:1;color:#718096;color:rgba(113,128,150,var(--text-opacity))}.text-gray-700{--text-opacity:1;color:#4a5568;color:rgba(74,85,104,var(--text-opacity))}.text-gray-900{--text-opacity:1;color:#1a202c;color:rgba(26,32,44,var(--text-opacity))}.underline{text-decoration:underline}.antialiased{-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.w-5{width:1.25rem}.w-8{width:2rem}.w-auto{width:auto}.grid-cols-1{grid-template-columns:repeat(1,minmax(0,1fr))}@media (min-width:640px){.sm\:rounded-lg{border-radius:.5rem}.sm\:block{display:block}.sm\:items-center{align-items:center}.sm\:justify-start{justify-content:flex-start}.sm\:justify-between{justify-content:space-between}.sm\:h-20{height:5rem}.sm\:ml-0{margin-left:0}.sm\:px-6{padding-left:1.5rem;padding-right:1.5rem}.sm\:pt-0{padding-top:0}.sm\:text-left{text-align:left}.sm\:text-right{text-align:right}}@media (min-width:768px){.md\:border-t-0{border-top-width:0}.md\:border-l{border-left-width:1px}.md\:grid-cols-2{grid-template-columns:repeat(2,minmax(0,1fr))}}@media (min-width:1024px){.lg\:px-8{padding-left:2rem;padding-right:2rem}}@media (prefers-color-scheme:dark){.dark\:bg-gray-800{--bg-opacity:1;background-color:#2d3748;background-color:rgba(45,55,72,var(--bg-opacity))}.dark\:bg-gray-900{--bg-opacity:1;background-color:#1a202c;background-color:rgba(26,32,44,var(--bg-opacity))}.dark\:border-gray-700{--border-opacity:1;border-color:#4a5568;border-color:rgba(74,85,104,var(--border-opacity))}.dark\:text-white{--text-opacity:1;color:#fff;color:rgba(255,255,255,var(--text-opacity))}.dark\:text-gray-400{--text-opacity:1;color:#cbd5e0;color:rgba(203,213,224,var(--text-opacity))}.dark\:text-gray-500{--tw-text-opacity:1;color:#6b7280;color:rgba(107,114,128,var(--tw-text-opacity))}}
</style>
<style>
   #wheelOfFortune {
   margin-top: 50px;
   display: inline-block;
   position: relative;
   overflow: hidden;
   }
   #wheel {
   display: block;
   }
   #spin {
   font: 1.5em/0 sans-serif;
   user-select: none;
   cursor: pointer;
   display: flex;
   justify-content: center;
   align-items: center;
   position: absolute;
   top: 50%;
   left: 50%;
   width: 30%;
   height: 30%;
   margin: -15%;
   background: #fff;
   color: #fff;
   box-shadow: 0 0 0 8px currentColor, 0 0px 15px 5px rgba(0, 0, 0, 0.6);
   border-radius: 50%;
   transition: 0.8s;
   }
   #spin::after {
   content: "";
   position: absolute;
   top: -17px;
   border: 10px solid transparent;
   border-bottom-color: currentColor;
   border-top: none;
   }
</style>
<style>
   @import  url("https://fonts.googleapis.com/css?family=Quicksand&display=swap");
   * {
   margin: 0;
   padding: 0;
   box-sizing: border-box;
   }
   h3 {
   font-family: Quicksand;
   }
   .alert {
   width: 80%;
   margin: 20px auto;
   padding: 10px;
   position: relative;
   border-radius: 5px;
   box-shadow: 0 0 15px 5px #ccc;
   }
   .close {
   position: absolute;
   width: 30px;
   height: 30px;
   opacity: 0.5;
   border-radius: 50%;
   right: 15px;
   top: 25px;
   text-align: center;
   font-size: 1.1em;
   cursor: pointer;
   }
   .simple-alert {
   background-color: #ebebeb;
   border-left: 5px solid #6c6c6c;
   }
   .simple-alert .close {
   border-color: #6c6c6c;
   color: #6c6c6c;
   }
   .success-alert {
   background-color: #a8f0c6;
   border-left: 5px solid #178344;
   }
   .success-alert .close {
   border-color: #178344;
   color: #178344;
   }
   .danger-alert {
   background-color: #f7a7a3;
   border-left: 5px solid #8f130c;
   }
   .danger-alert .close {
   border-color: #8f130c;
   color: #8f130c;
   }
   .warning-alert {
   background-color: #ffd48a;
   border-left: 5px solid #8a5700;
   }
   .warning-alert .close {
   border-color: #8a5700;
   color: #8a5700;
   }
   #message{
   display: none;
   }
   .container{
   display: flex;
   flex-direction: column;
   align-items: center;
   }
</style>
<div class="row justify-content-center">
   <div class="col-md-8">
      <div class="card card-with-shadow-sm h-100">
         <div class="card-header">
            <h1 style="text-align:center;color:#2ECC71;" class="mb-0"> Your today's spin {{today_user_spin(Auth::user()->id)}}</h1>
         </div>
         <div class="card-body px-4">
            <div class="container">
                <div id="wheelOfFortune">
                    <canvas id="wheel" width="300" height="300"></canvas>
                    <div id="spin" class="btn" href="">SPIN</div>
                </div>
                <div class="text-center mt-4">
                    <button type="button" class="btn btn-success" @if(today_user_spin(Auth::user()->id) >= spin_setting()->daily_spin) onclick="spinAlert()" @else onclick="spinThisBoard()" @endif>Start Play</button>
                </div>
                <div id="message" class="alert danger-alert" style="width: 300px; text-align: center; color: #000;">
                    <p class="m-0" id="message_text" class="text-white"></p>
                </div>
            </div>
            <br><br>
            <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-5004657012524929"
               crossorigin="anonymous"></script>
            <!-- hori -->
            <ins class="adsbygoogle"
               style="display:block"
               data-ad-client="ca-pub-5004657012524929"
               data-ad-slot="3731825161"
               data-ad-format="auto"
               data-full-width-responsive="true"></ins>
            <script>
               (adsbygoogle = window.adsbygoogle || []).push({});
            </script>
            <script>
               var spinClickFlag = false;
               var spinClicked = false;
               const sectors = [
               {color:"{{spin_setting()->part_one_bg}}", label:"{{spin_setting()->part_one_mark}}"},
               {color:"{{spin_setting()->part_two_bg}}", label:"{{spin_setting()->part_two_mark}}"},
               {color:"{{spin_setting()->part_three_bg}}", label:"{{spin_setting()->part_three_mark}}"},
               {color:"{{spin_setting()->part_four_bg}}", label:"{{spin_setting()->part_four_mark}}"},
               {color:"{{spin_setting()->part_five_bg}}", label:"{{spin_setting()->part_five_mark}}"},
               {color:"{{spin_setting()->part_six_bg}}", label:"{{spin_setting()->part_six_mark}}"},
               {color:"{{spin_setting()->part_seven_bg}}", label:"{{spin_setting()->part_seven_mark}}"},
               ];
               var mark = -1;
               
               const rand = (m, M) => Math.random() * (M - m) + m;
               const tot = sectors.length;
               const EL_spin = document.querySelector("#spin");
               const ctx = document.querySelector("#wheel").getContext('2d');
               const dia = ctx.canvas.width;
               const rad = dia / 2;
               const PI = Math.PI;
               const TAU = 2 * PI;
               const arc = TAU / sectors.length;
               
               const friction = 0.991; // 0.995=soft, 0.99=mid, 0.98=hard
               let angVel = 0; // Angular velocity
               let ang = 0; // Angle in radians
               
               const getIndex = () => Math.floor(tot - ang / TAU * tot) % tot;
               
               function drawSector(sector, i) {
                   const ang = arc * i;
                   ctx.save();
                   // COLOR
                   ctx.beginPath();
                   ctx.fillStyle = sector.color;
                   ctx.moveTo(rad, rad);
                   ctx.arc(rad, rad, rad, ang, ang + arc);
                   ctx.lineTo(rad, rad);
                   ctx.fill();
                   // TEXT
                   ctx.translate(rad, rad);
                   ctx.rotate(ang + arc / 2);
                   ctx.textAlign = "right";
                   ctx.fillStyle = "#fff";
                   ctx.font = "bold 30px sans-serif";
                   ctx.fillText(sector.label, rad - 10, 10);
                   //
                   ctx.restore();
               };
               
                function rotate() {
                    const sector = sectors[getIndex()];
                    ctx.canvas.style.transform = `rotate(${ang - PI / 2}rad)`;
                    EL_spin.textContent = !angVel ? "SPIN" : "Go";
                    EL_spin.style.background = sector.color;
                }
               
                function frame() {
                    if (!angVel){
                        if(spinClickFlag === true ) {
                            spinClickFlag = false;
                            const sector = sectors[getIndex()];
                            mark = sector.label;
                            
                            $.ajax({
                                url: "{{ route('user.add-spin-mark-to-earning') }}",
                                type:"POST",
                                data:{
                                    mark: mark,
                                    _token: '{{csrf_token()}}',
                                },
                                success:function(data) {
                                    window.location.reload() ;
                                },
                            });
                        }
                        return;
                    }
                    angVel *= friction; // Decrement velocity by friction
                    if (angVel < 0.002) angVel = 0; // Bring to stop
                    ang += angVel; // Update angle
                    ang %= TAU; // Normalize angle
                    rotate();
                }
               
                function engine() {
                    frame();
                    requestAnimationFrame(engine)
                }
               
                // INIT
                sectors.forEach(drawSector);
                rotate(); // Initial rotation
                engine(); // Start engine
                // EL_spin.addEventListener("click", () => {
                //     if(!spinClicked){
                //         if (!angVel) angVel = rand(0.25, 0.35);
                //         spinClickFlag = true;
                //         spinClicked = true;
                //     }
                // });
                
                function spinThisBoard(){
                    if(!spinClicked){
                        if (!angVel) angVel = rand(0.25, 0.35);
                        spinClickFlag = true;
                        spinClicked = true;
                    }
                }
                
                function spinAlert(){
                    $("#message_text").html('You reached daily spin limit!');
                    $("#message").show();
                }
                
                $(".close").click(function() {
                    $("#message").fadeOut();
                });
               
            </script>
         </div>
      </div>
   </div>
</div>
@endsection
@section('js')
@endsection
